require.config({
    // Paths assume the js suffix
    paths: {
        // Config
        'externalLinksJson': '../external-links.json',
        'resourceDirectoryJson': '../resource-directory.json',
        'jqm.config': 'js/config/jqm.config',
        'notificationInfoJson': 'modules/notification-info/notification-info-popup-content.json',
        'versionInfoJson': '../version.json',
        'featureFlagJson': '../config.json',

        // Libraries
        'backbone': '../libs/js/backbone-min',
        'backbone.radio': '../libs/js/backbone.radio',
        'datepicker': '../libs/js/datepicker/bootstrap-datepicker.min',
        'FormParams': '../libs/js/jquery.formparams',
        'Jasmine': '../test/libs/js/jasmine-1.3.1',
        'JasmineHtml': '../test/libs/js/jasmine-html-1.3.1',
        'JasmineJQuery': '../test/libs/js/jasmine-jquery',
        'jquery': '../libs/js/jquery-2.1.4.min',
        'jqm': '../libs/js/jquery.mobile-1.4.5.min',
        'jwt_decode': '../libs/js/jwt-decode',
        'marionette': '../libs/js/backbone.marionette.min',
        'moment': '../libs/js/moment-2.7.0',
        'momentTz': '../libs/js/moment-timezone-with-data.min',
        'underscore': '../libs/js/lodash.min',
        'lodashDatestrMixin': 'js/mixin/lodash-datestr-mixin',
        'jquery.mask': '../libs/js/jquery.mask',
        'jquery.validate': '../libs/js/jquery.validate',
        'jquery.validate.additional-methods': '../libs/js/jquery.validate.additional-methods',
        'Vent': 'js/vent',
        'App': 'app',
        'GoogleAnalyticsProvider': 'googleAnalyticsProvider',
        'FontFaceObserver': '../libs/js/fontfaceobserver',
        // paginator

        'backgrid': '../libs/js/paginator/backgrid',
        'backbone.paginator': '../libs/js/paginator/backbone.paginator',
        'backgrid-paginator': '../libs/js/paginator/extensions/backgrid-paginator',


        // Plugin for text resources, e.g.: templates
        'text': '../libs/js/text',
        'json': '../libs/js/json',

        // Tools
        'loadingSpinner': 'modules/loading-spinner/loading-spinner',
        'jquery-custom': 'js/tools/jquery-custom',
        'jquery.validate.config': 'js/config/jquery.validate.config',
        'jquery.mask.config': 'js/config/jquery.mask.config',
        'IOSOrientationChangeFix': 'js/tools/ios-orientationchange-fix.min',
        'UnderscoreRenderer': 'js/tools/marionette.underscore-renderer',
        'afsFontFaceObserver': 'js/tools/afs-font-face-observer',

        // Models
        'User': 'models/user',

        // Views
        'HeaderView': 'modules/page/header/header-view',
        'MainView': 'modules/page/main-view',

        // Router
        'AppRouter': 'js/router',
        'appointmentsRouter': 'modules/appointments/appointments-router',
        'notificationsRouter': 'modules/notifications/notifications-router',

        // Error and Authentication Handlers
        'connectionModule': 'modules/connection/connection-module',
        'Global': 'js/tools/global',

    },
    waitSeconds: 200,
    shim: {
        'jquery': {exports: '$'},
        'FontFaceObserver': {exports: 'FontFaceObserver'},
        'FormParams': {deps: ['jquery']},
        'Global': {
            deps: [
                'moment',
                'backbone',
                'marionette',
            ],
        },
        'backbone': {
            deps: [
                'jquery',
                'underscore',
            ],
            exports: 'backbone',
        },
    },
    deps: [
        'lodashDatestrMixin',
        'UnderscoreRenderer',
        'jquery.mask.config',
        'jqm.config',
        'jquery-custom',
        'main',
        'afsFontFaceObserver',
    ],
});
